
#ifndef 		_HT8_H_
#define 		_HT8_H_

/*---------- Includes MCU -----------------------------------------------------------*/
#include    "ht66f2370.h"
#include		"typedef.h"

/*---------- MCU ISR vector address--------------------------------------------------*/
#define		RES_VECADR			0x0000
#define		INT0_VECADR			0x0004
#define		INT1_VECADR			0x0008
#define		CMP0_VECADR			0x000C
#define		CMP1_VECADR			0x0010
#define		MF0_VECADR			0x0014
#define		MF1_VECADR			0x0018
#define		ADC_VECADR			0x001C
#define		MF2_VECADR			0x0020
#define		TB0_VECADR			0x0024
#define		TB1_VECADR			0x0028
#define		MF3_VECADR			0x002C
#define		INT2_VECADR			0x0030
#define		INT3_VECADR			0x0034
#define		MF4_VECADR			0x0038
#define		MF5_VECADR			0x003C
/*---------- system clock define ---------------------------------------------------*/
#define		FSYS4MHZ 			0						/* system clock = 4MHZ */
#define		FSYS8MHZ				1						/* system clock = 8MHZ */
#define		FSYS12MHZ			2						/* system clock = 12MHZ */
#define		FSYS16MHZ			3						/* system clock = 16MHZ */

#define		SYSTEM_CLOCK		FSYS8MHZ

#define		T1MS					4
/*---------- BC7701 Interface I/O define---------------------------------------------*/
/*---------- BUTTON Interface I/O define---------------------------------------------*/

void 	SystemClockConfigure(void);
void 	SysTick2msConfigure(void);
void	DelayX10us(u8 cnt);
void 	DelayXmSec(u8 xs);				

#endif		/* _HT8_H_ */
